//
//  MCObjectPicker.h
//  MCApplication
//
//  Created by Ali Lalani on 1/26/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCWindowController.h"
#import "MCMenuManagerSupportProtocol.h"

@class MCOPAbstractPane,MCWebKitTemplateView;

@interface MCObjectPicker : MCWindowController <MCMenuManagerSupport>{
	IBOutlet NSView            *paneContentView;
	IBOutlet NSTableView       *objectTypeTableView;
	IBOutlet NSSplitView       *splitView;
	IBOutlet NSArrayController *objectTypesController;
	IBOutlet NSButton          *nextBatchButton;
	IBOutlet NSButton          *previousBatchButton;
	IBOutlet NSTextField       *batchDescription;

	NSMutableArray *_objectTypes;

	NSInteger selectedIndex;

	BOOL infoPaneVisible;
	MCWebKitTemplateView *infoPane;
}

+ (MCObjectPicker *)defaultPicker;

- (void)configure;

#pragma mark InfoPane
- (IBAction)toggleInfoPane:(id)sender;
- (NSRect)paneFrame;
- (NSRect)infoPaneFrame;
- (void)updateInfoPane;

- (void)selectPaneAtIndex:(int)anIndex;
- (void)configurePaneAtIndex:(int)anIndex;

- (MCOPAbstractPane *)selectedPane;

- (IBAction)switchToObjectType:(id)sender;
- (IBAction)nextBatch:(id)sender;
- (IBAction)previousBatch:(id)sender;

- (void)validateBatchWidgets;

#pragma mark Accessors
- (NSArrayController *)objectTypesController;

- (NSMutableArray *)objectTypes;
- (void)setObjectTypes:(NSMutableArray *)anObjectTypes;

- (BOOL)infoPaneVisible;
- (void)setInfoPaneVisible:(BOOL)flag;

- (MCWebKitTemplateView *)infoPane;
- (void)setInfoPane:(MCWebKitTemplateView *)anInfoPane;
@end
